<?php

/**
 * @version    4.3.2
 * @package     com_mymaplocations
 * @copyright   JoomUnited (C) 2011. All rights reserved.
 * @license     http://www.gnu.org/copyleft/gpl.html GNU/GPL
 */
defined('_JEXEC') or die('Restricted access');

jimport('joomla.form.form');
JLoader::register('K2Plugin', JPATH_ADMINISTRATOR . '/components/com_k2/lib/k2plugin.php');
require_once(JPATH_SITE .'/components/com_mymaplocations/helpers/mymaplocations.php');
JTable::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_mymaplocations/tables');

class plgK2MyMaplocations extends K2Plugin {

    var $pluginName = 'mymaplocations';
    var $pluginNameHumanReadable = 'My Map Locations';

    function onRenderAdminForm(&$item, $type, $tab = '') {
	 MyMaplocationsHelper::loadLanguage();
        $plugin = JPluginHelper::getPlugin('k2', $this->pluginName);
        $pluginParams = new JRegistry();
        $pluginParams->loadString($plugin->params, 'JSON');
        $catfilter = $pluginParams->get('catfilter', 0);
        $catids = $pluginParams->get('category_id', 0);
        $catscript = " var mycatid = new Array();";
        $n = 0;
        $html = "";
        $found = false;
        if ($catfilter != 0) {
            foreach ($catids as $catid) {
                if ($item->catid == $catid) {
                    $html.="<style type='text/css'>#mymaplocation{display:block;}</style>";
                    $found = true;
                }
                if ($n == 0) {
                    $catscript.="if(selectedValue==" . $catid . "){ jQuery('#mymaplocation').show();}";
                } else {
                    $catscript.="else if(selectedValue==" . $catid . "){ jQuery('#mymaplocation').show();}";
                }
                $n++;
            }
            if ($found == false) {
                $html.="<style type='text/css'>#mymaplocation{display:none;}</style>";
            }
            $catscript.="else{ jQuery('#mymaplocation').hide();}";
        }

        if ($type == 'item' && $tab == 'content') {
            if (!empty($tab)) {
                $path = $type . '-' . $tab;
            } else {
                $path = $type;
            }
            if (!isset($item->plugins)) {
                $item->plugins = NULL;
            }
            $form = JForm::getInstance('form', JPATH_ADMINISTRATOR . '/components/com_mymaplocations/models/forms/location.xml');

            $db = JFactory::getDBO();
            $sql = "select * from #__mymaplocations_location where component=" . $db->Quote('com_k2') . "AND extra_id=" . $db->Quote($item->id);
            $db->setQuery($sql);
            $result = $db->loadObject();
            if (!empty($result)) {
                $form->bind($result);
                $latlng = $result->latitude . "," . $result->longitude;
            } else {
                $latlng = "44.824708,-0.615234";
            }
			$params=JComponentHelper::getParams('com_mymaplocations');
			$googleapi=$params->get('googleapi','AIzaSyDyJXSfY3iyCQCku7oKqFiZMOV6aFXQxls');
			$key="";
			if($googleapi){
				$key='&amp;key='.$googleapi;
			}
           $document = JFactory::getDocument();
            $document->addStyleSheet(JURI::root() . '/components/com_mymaplocations/assets/css/materialize.css');
        require_once  (JPATH_SITE.'/components/com_mymaplocations/helpers/mymaplocations.php'); 
            if(method_exists('MyMapLocationsHelper','getBackEndJs'))
               {
                $script="";
                  if ((@$result->latitude)) {
                 MyMaplocationsHelper::getBackEndJs(false,$result->latitude ,$result->longitude);
                } else {
                 MyMaplocationsHelper::getBackEndJs(false);
                              }
               }else {
            $script='<script src="//maps.google.com/maps/api/js?v=3&amp;libraries=places'.$key.'" type="text/javascript"></script><script src="' . JURI::root() . 'administrator/components/com_mymaplocations/assets/site.js" type="text/javascript"></script>';
            $script .= <<<EOF
	      
              <script type="text/javascript">
      var latlng = new google.maps.LatLng($latlng);
      var options = {
          zoom: 5,
          center: latlng,
          mapTypeId: google.maps.MapTypeId.ROADMAP,
          draggableCursor: "crosshair",
          streetViewControl: false
        };
		var map = new google.maps.Map(document.getElementById("map"), options);
	  	var marker = new google.maps.Marker({
					    position: latlng,
					    map: map
					    });

      jQuery("#zoom").html(5);
		  google.maps.event.addListener(map,"click", function(location)
      {
        GetlocationInfo(location.latLng);
      });
      google.maps.event.addListener(map,'zoom_changed', function(oldLevel, newLevel)
      {
        jQuery("#zoom").html(map.getZoom());
      });
      var myPano = new google.maps.StreetViewPanorama(document.getElementById("pano"),
            { visible:false});
      myPano.setPov({
        heading: 265,
        zoom:1,
        pitch:0});
      jQuery('#pano').hide();
      google.maps.event.trigger(myPano, 'resize');

			// autocomplete
			var autocomplete = new google.maps.places.Autocomplete(document.getElementById('postcode'), {});
			google.maps.event.addListener(autocomplete, 'place_changed', function() {
				jQuery("#locations").html("");
				jQuery("#error").html("");
				var place = autocomplete.getPlace();
				if (place.place_id ) {
                                                jQuery("#place_id_data").show();
											jQuery("#place_id_div").html("We have found Google Place <a href='"+place.url+"' class='btn btn-primary' target='_blank'>"+place.name+"</a> linked with data.Click here to copy data directly to our fields from Google places API  <input type='button' class='btn btn-inverse' value='insert' onclick='insertGooglePlaces()'/>");
												}
				Gotolocation(place.geometry.location);
			});

      var initListener;
      var marker;
      function StartStreetView() {
        // street view
        if (jQuery("#streetViewBtn").val() == "Start StreetView") {
          initListener = google.maps.event.addListener(myPano, "position_changed", handlePanoMove);
          jQuery('#pano').show();
          myPano.setVisible(true);
          jQuery("#streetViewBtn").val("End StreetView");
          google.maps.event.trigger(myPano, 'resize');
          GotoLatLong();
        }
        else {
          google.maps.event.removeListener(initListener);
          myPano.setVisible(false);
          jQuery('#pano').hide();
          jQuery("#streetViewBtn").val("Start StreetView");
          google.maps.event.trigger(myPano, 'resize');
        }
      }

			function Geocode()
			{
				jQuery("#locations").html("");
                                                jQuery("#error").html("");
                                                var place = autocomplete.getPlace();
												if(typeof place === 'undefined'){
															var localSearch = new google.maps.Geocoder();
                                                var postcode = jQuery("#postcode").val();
                                                localSearch.geocode({ 'address': postcode },
                                                function(results, status) {
                                                    if (results.length == 1) {
                                                        var result = results[0];
                                                        var location = result.geometry.location;
                                                        Gotolocation(location);
                                                    }
                                                    else if (results.length > 1) {
                                                        jQuery("#error").html("Multiple addresses found");
                                                        // build a list of possible addresses
                                                        var html = "";
                                                        for (var i=0; i<results.length; i++) {
                                                            html += '<a href="javascript:Gotolocation(new google.maps.LatLng(' + 
                                                                results[i].geometry.location.lat() + ', ' + results[i].geometry.location.lng() + '))">' + 
                                                                results[i].formatted_address + "</a><br/>";
                                                        }
                                                        jQuery("#locations").html(html);
                                                    }
                                                    else {
                                                        jQuery("#error").html("Address not found");
                                                    }
                                                });	
																}
																else
																{
												if (place.place_id ) {
																
                                                jQuery("#place_id_data").show();
												jQuery("#place_id_div").html("We have found Google Place <a href='"+place.url+"' class='btn btn-primary' target='_blank'>"+place.name+"</a> linked with data.Click here to copy data directly to our fields from Google placs API  <input type='button' class='btn btn-inverse' value='insert' onclick='insertGooglePlaces()'/>");
																}
																Gotolocation(place.geometry.location);
												}
			}
			function useGeocode()
			{
				if (navigator.geolocation)
					{
						navigator.geolocation.getCurrentPosition(showPosition);
					}
				else
				{
					x.innerHTML="Geolocation is not supported by this browser.";
				}
			}
			function showPosition(position)
			{
				document.getElementById('latitude').value= position.coords.latitude;
				document.getElementById('longitude').value=position.coords.longitude;
				ReverseGeocoding(position.coords.latitude, position.coords.longitude, '#address_text');
				Gotolocation(new google.maps.LatLng( position.coords.latitude, position.coords.longitude));
				
			}
			

			function Gotolocation(location) {
				GetlocationInfo(location);
				map.setCenter(location);
			}

      function GetlocationInfo(latlng)
      {
        if (latlng != null)
        {
          ShowLatLong(latlng);
          UpdateStreetView(latlng);
        }
      }

      function GotoLatLong()
      {
        if (jQuery("#lat").val() != "" && jQuery("#long").val() != "") {
          var lat = jQuery("#lat").val();
          var long = jQuery("#long").val();
          var latLong = new google.maps.LatLng(lat, long);
          ShowLatLong(latLong);
          map.setCenter(latLong);
          UpdateStreetView(latLong);
        }
      }

      function ShowLink(){
        jQuery("#mapLink").html('<a href="https://maps.google.com/?ll=' + jQuery("#lat").val() +
          ',' + jQuery("#long").val() + '&z=' + jQuery("#zoom").html() + '">Link for this map</a>');
      }

			function toDMS(latOrLng) {
				var d = parseInt(latOrLng);
				var md = Math.abs(latOrLng - d) * 60;
				var m = Math.floor(md);
				var sd = (md - m) * 60;
				return Math.abs(d) + "\u00B0 " + m + "' " + roundNumber(sd, 4) + '"';
			}

			function latToDMS(lat) {
				var dms = toDMS(lat);
				if (lat > 0)
					return dms + "N";
				else
					return dms + "S";
			}

			function lngToDMS(lng) {
				var dms = toDMS(lng);
				if (lng > 0)
					return dms + "E";
				else
					return dms + "W";
			}

      function ShowLatLong(latLong)
      {
        // show the lat/long
        if (marker != null) {
          marker.setMap(null);
        }
        marker = new google.maps.Marker({
          position: latLong,
          map: map});
        jQuery("#latitude").val(roundNumber(latLong.lat(), 6));
        jQuery("#longitude").val(roundNumber(latLong.lng(), 6));
				jQuery("#latDMS").html(latToDMS(latLong.lat()));
				jQuery("#lngDMS").html(lngToDMS(latLong.lng()));
        ShowLink();
        GetElevation(latLong.lat(), latLong.lng(), '#elevation');
        ReverseGeocoding(latLong.lat(), latLong.lng(), '#address_text');
      }
function ReverseGeocoding(lat, long, selector){
    var geocoder = new google.maps.Geocoder();
    var latLong = new google.maps.LatLng(lat, long);
    var streetNumber = '';
            var streetName = '';
            var country = '';
            var postalCode = '';
            var city = '';
	    var estate='';
    geocoder.geocode({'latLng': latLong}, function(results, status) {
      if (status == google.maps.GeocoderStatus.OK) {
        if (results) {
         
          var foundAddress = false;
          for (var i=0; i<results.length; i++) {
            if ((results[i].types[0] == 'street_address') || (results[i].types[0] == 'route')) {
              results[i].address_components.each(function (el) {

                    el.types.each(function (type) {
                        if (type == 'street_number') {
                            streetNumber = el.long_name;
                        }

                        if (type == 'route') {
                            streetName = el.long_name;
                        }
			if (type == 'administrative_area_level_1') {
                            estate = el.long_name;
                        }
                        if (type == 'country') {
                            country = el.long_name;
                        }

                        if (type == 'postal_code') {
                            postalCode = el.long_name;
                        }

                        if (type == 'locality') {
                            city = el.long_name;
                        }
                    })
                });
		 jQuery("#address").val(streetNumber+" "+streetName);
		 jQuery("#town").val(city);
		 jQuery("#country").val(country);
		 jQuery("#postal").val(postalCode);
		 jQuery("#locationstate").val(estate);
              foundAddress = true;
	      break;
            }
          }
          if (!foundAddress) {
             jQuery("#address").html(results[0].formatted_address);
          }
        }
      }
    });
  }

      function UpdateStreetView(latLong)
      {
        // street view
        if (jQuery("#streetViewBtn").val() == "End StreetView") {
          jQuery("#panoError").html("");
          myPano.setVisible(true);
          myPano.setPosition(latLong);
          // also set via the service API so we know if there is a view available
          var service = new google.maps.StreetViewService();
          service.getPanoramaBylocation(latLong, 50,
            function(result, status) {
              if (status != google.maps.StreetViewStatus.OK) {
                jQuery("#panoError").html("No street view available");
                myPano.setVisible(false);
              }
            }
          );
        }
      }

      function handlePanoMove(location)
      {
        ShowLatLong(myPano.getPosition());
      }
      function copyData()
      {
	var lat=document.getElementById('latitude').value;
	var long=document.getElementById('longitude').value;
	document.getElementById('latitude').value=lat;
	document.getElementById('longitude').value=long;
      }
	  function insertGooglePlaces() {
                                                //code
												   var place = autocomplete.getPlace();
												   document.getElementById('place_id').value=place.place_id;
												
												if (typeof place.international_phone_number !== 'undefined') {
												   document.getElementById('phone').value=place.international_phone_number;
												}else
												{
																document.getElementById('phone').value="";
												}
												if (typeof place.website !== 'undefined') {
												   document.getElementById('contactlink').value=place.website;
												}else
												{
																document.getElementById('contactlink').value="";
												}
												
												
																document.getElementById('hours').value="";
													 
													
		
                                            }
  /* ]]> */
  </script>
EOF;
               }
            $script.="<script type='text/javascript'>  jQuery('#catid').change(function() {
       var selectedValue =  jQuery(this).val();
       $catscript
       var data = mycatid.indexOf(selectedValue);
   
	});
 </script>";
            $html.='<style type="text/css">
	  .width100
	  {
	    width:100%;
	    float:left;
	  }
	  .width60
	  {
	    width:60%;
	    float:left;
	    
	  }
	  .width40
	  {
	    float: left;
	    width: 39%;
	  }
      .itemAdditionalField .itemAdditionalData
      {
        width:100%;
      }
	  #mapcatid_chzn,.catid .chzn-drop
	  {
	    min-width:120px;
	  }
	  #location-form .table th,	  #location-form .table td
	  {
		border-top:0px;
	  }
	  </style>
	  <div class="width100" id="location-form"><div class="width60"><table class="adminFormK2 table">
			<tbody><tr style="display:none;">
			<td class="adminK2LeftCol" ><label>' . $form->getLabel('catid') . '</label></td>
									<td class="adminK2RightCol catid">
			' . str_replace('catid', 'mapcatid', $form->getInput('catid')) . '</td>
								</tr>
								<tr>
			<td class="adminK2LeftCol"><label>' . $form->getLabel('logo') . '</label></td>
									<td class="adminK2RightCol">
				' . $form->getInput('logo') . '</td>
								</tr>
								<tr>
                            <td class="adminK2LeftCol"><label>' . $form->getLabel('icon') . '
				</label></td>
			<td class="adminK2RightCol">' . $form->getInput('icon') . '</td>
								</tr>
								<tr>
                            <td class="adminK2LeftCol"><label>

			' . $form->getLabel('description') . '</label></td>
			<td class="adminK2RightCol editor-panel">
			<div class="clr"></div>
			' . $form->getInput('description') . '</td></tr></table></div><div class="width40">
	<div class="alert alert-success"  id="place_id_data" style="display:none;">
         <button type="button" class="close" data-dismiss="alert">&times;</button>
		 <div id="place_id_div"></div>
		</div>
        <div id="container_mml">
 <input id="postcode" autocomplete="off"  style="width:250px;" type="text" class="search-query"/><input type="button" onclick="Geocode()" value="' . JTEXT::_("COM_MYMAPLOCATIONS_FORM_LBL_STORE_SEARCH") . '"  class="btn"/>
 </div>
	<div class="navbar-form pull-left" >
	<label><span class="label">' . JTEXT::_("COM_MYMAPLOCATIONS_FORM_LBL_STORE_LATITUDE") . '</span></label>' . $form->getInput('latitude') . '
	</div>
							<div class="navbar-form pull-left" style="margin-bottom:10px;">
	<label><span class="label"> ' . JTEXT::_("COM_MYMAPLOCATIONS_FORM_LBL_STORE_LONGITUDE") . '</span></label>' . $form->getInput('longitude') . '
							</div>
	<div id="map" style="width: 100%; height: 300px;clear:both;"></div>' . $script . '<table class="adminFormK2 table"><tr>
                            <td class="adminK2LeftCol"><label>' . $form->getLabel('address') . '</label></td>
									<td class="adminK2RightCol">
			' . $form->getInput('address') . '</td>
								</tr>
								<tr>
                            <td class="adminK2LeftCol"><label>
                        ' . $form->getLabel('town') . '</label></td>
			<td class="adminK2RightCol">
			' . $form->getInput('town') . '</td>
								</tr>
								<tr>
                            <td class="adminK2LeftCol"><label>' . $form->getLabel('locationstate') . '</label></td>
			<td class="adminK2RightCol">
			' . $form->getInput('locationstate') . '</td>
								</tr>
								<tr>
                            <td class="adminK2LeftCol"><label>' . $form->getLabel('country') . '</label></td>
			<td class="adminK2RightCol">
			' . $form->getInput('country') . '</td>
								</tr>
								<tr>
                            <td class="adminK2LeftCol"><label>' . $form->getLabel('postal') . '</label></td>
			<td class="adminK2RightCol">
			' . $form->getInput('postal') . '</td>
								</tr>
                                                                			<tr>
                            <td class="adminK2LeftCol"><label>' . $form->getLabel('contactlink') . '</label></td>
			<td class="adminK2RightCol">
			' . $form->getInput('contactlink') . '</td>
								</tr>
			<tr>
                            <td class="adminK2LeftCol"><label>' . $form->getLabel('phone') . '</label></td>
			<td class="adminK2RightCol">
			' . $form->getInput('phone') . '</td>
								</tr><tr>
                            <td class="adminK2LeftCol"><label>' . $form->getLabel('hours') . '</label></td>
			<td class="adminK2RightCol">
			' . $form->getInput('hours') . '</td>
								</tr>
								<tr>
                            <td class="adminK2LeftCol"><label>' . $form->getLabel('place_id') . '</label></td>
			<td class="adminK2RightCol">
			' . $form->getInput('place_id') . '</td>
								</tr>
								</table>
								
        </div></div>';



            $plugin = new JObject;

            $plugin->set('name', JTEXT::_("COM_MYMAPLOCATIONS"));

            $plugin->set('fields', $html);

            return $plugin;
        }
    }

    function onAfterK2Save(&$row, $isnew) {
        $plugin = JPluginHelper::getPlugin('k2', $this->pluginName);
        $pluginParams = new JRegistry();
        $pluginParams->loadString($plugin->params, 'JSON');
        $catids = $pluginParams->get('category_id', 0);
        $found = false;
		if($catids)
		{
        foreach ($catids as $catid) {
            if ($row->catid == $catid) {
                $found = true;
            }
        }
		}
        $catfilter = $pluginParams->get('catfilter', 0);
        if ($catfilter == 0) {
            $found = true;
        }
        if ($found == false) {
            return;
        }
        $db = JFactory::getDBO();
        $sql = "select id from #__mymaplocations_location where component=" . $db->Quote('com_k2') . "AND extra_id=" . $db->Quote($row->id);
        $db->setQuery($sql);
        $mapitem = $db->loadObject();

        $type = 'location';
        $prefix = 'MyMaplocationsTable';
        $config = array();
        $table = JTable::getInstance($type, $prefix, $config);
        $mapdata = JFactory::getApplication()->input->getArray();
		$mapdata['description']=JFactory::getApplication()->input->post->get('description',null,'RAW');
		$mapdata['hours']=JFactory::getApplication()->input->post->get('hours',null,'RAW');
	   if((!$mapdata['latitude'])||(!$mapdata['longitude']))
        {
            return;
        }
        if (!empty($mapitem->id)) {
            $mapdata['id'] = $mapitem->id;
        } else {
            unset($mapdata['id']);
        }
        $mapdata['name'] = $row->id . '-' . $row->title;
        $mapdata['alias'] = $row->id . '-' . $row->title;
        $mapdata['catid'] = $mapdata['mapcatid'];
        $mapdata['component'] = 'com_k2';
        $mapdata['extra_id'] = $row->id;
		$mapdata['state']=1;
        $table->bind($mapdata);
        if (!$table->check()) {

            JFactory::getApplication()->enqueueMessage($table->getError(), 'error');
        }
        if (!$table->store()) {
            JFactory::getApplication()->enqueueMessage($table->getError(), 'error');
        }
    }

    function onK2AfterDisplay(& $item, & $params, $limitstart) {
        $plugin = JPluginHelper::getPlugin('k2', $this->pluginName);
        $address="";
        $pluginParams = new JRegistry();
		$img="";
        $pluginParams->loadString($plugin->params, 'JSON');
        $catids = $pluginParams->get('category_id', 0);
        $height = $pluginParams->get('height', 400);
        $zoom = $pluginParams->get('zoom', '10');
        $type = $pluginParams->get('type', 'google');
		$description_view=$pluginParams->get('description_view', '1');
		if($description_view)
		{
			$width = $pluginParams->get('width', '70%');
		}
		else
		{
			$width = "100%";
			
		}
		$category_view=$pluginParams->get('category_view', 0);
	    $found = false;
        if (!empty($catids)) {
            foreach ($catids as $catid) {
                if ($item->catid == $catid) {
                    $found = true;
                }
            }
        }
        $catfilter = $pluginParams->get('catfilter', 0);
        if ($catfilter == 0) {
            $found = true;
        }
        if ($found == false) {
            return;
        }
	if($category_view==0)
	{
	    $view=JFactory::getApplication()->input->getString('view');
	    if($view!="item")
	    {
		return;
	    }
	}
        $output = '';
        $img = '';
        $db = JFactory::getDBO();
        $sql = "SELECT a.*,k.title as name,k.alias as k2alias,k.catid as k2catid,cat.alias as k2catalias  FROM #__mymaplocations_location AS a LEFT JOIN #__k2_items AS k ON k.id = a.extra_id LEFT JOIN #__k2_categories AS cat ON cat.id = k.catid where a.state=1 and  a.component=" . $db->Quote('com_k2') . " AND k.published =1 AND a.extra_id=" . $db->Quote($item->id);
        $db->setQuery($sql);
        $mapitem = $db->loadObject();
		
	if(!($mapitem))
	{
	    return;
	}
	if(($mapitem->latitude==0)&&($mapitem->longitude==0))
	{
	    return;
	}
	
	$mapitem->google_maptype = $pluginParams->get('google_maptype', 'ROADMAP');
	$mapitem->bing_maptype = $pluginParams->get('bing_maptype', 'road');
	$mapitem->map_design = $pluginParams->get('map_design',1);
	$mapitem->openmapstyle = $pluginParams->get('openmapstyle',1);
        if (!empty($mapitem)) {
            $mapitems[0] = $mapitem;
            $map = MyMaplocationsHelper::createMap($mapitems, $width, $height, $zoom, $type);

            $output = '<div class="row-fluid mymaplocation itemAuthorBlock" style="width:100%;float:left;"><div class="locationsearch span12" id="locationsearch">';
            if($description_view)
			{
			$address = "";
            if (!empty($mapitem->address)) {
                $address.='<span property="v:street-address"><i class="icon-home"></i>' . $mapitem->address . '</span> <br/>';
            }
            if (!empty($mapitem->town)) {
                $address.='<span property="v:locality">' . $mapitem->town . ',</span> ';
            }
            if (!empty($mapitem->locationstate)) {
                $address.='<span property="v:region">' . $mapitem->locationstate . '</span>.<br/>';
            }
            if (!empty($mapitem->country)) {
                $address.='<span>' . $mapitem->country . '</span> ,';
            }
            if (!empty($mapitem->postal)) {
                $address.='<span>' . $mapitem->postal . '</span> ';
            }
	    
        if (!empty($mapitem->phone)) {
            $address.='<br/><span><i class="icon-phone"></i><span itemprop="telephone">' . $mapitem->phone . '</span>';
        }
        if (!empty($mapitem->hours)) {
            $address.='<br/><span><i class="icon-calendar"></i>' . $mapitem->hours . '</span>';
        }
            
			}
			$contact="";
			if($mapitem->contactlink)
			{
				$contact=MyMaplocationsHelper::createContactLink($mapitem->contactlink);
			}
			$output.= $map . '<div style="margin-left: 10px; float: left;" class="mmladdress">
	' . $address . '<br/>
	' . $contact . '<br/>
      ' . $mapitem->description . '
    </div> </div></div><div class="clr"></div>';
        }
        return $output;
    }

}

?>
