<?php
/**
 * @package        RSForm! Pro
 * @copyright  (c) 2007 - 2016 RSJoomla!
 * @link           https://www.rsjoomla.com
 * @license        GNU General Public License http://www.gnu.org/licenses/gpl-3.0.en.html
 */

defined('_JEXEC') or die;

/**
 * Class plgSystemRSFPSignature
 */
class plgSystemRSFPSignature extends JPlugin
{
	/**
	 * @var bool
	 */
	protected $autoloadLanguage = true;

	/**
	 * @var int
	 */
	protected $componentId = 2787;

	/**
	 * plgSystemRSFPSignature constructor.
	 *
	 * @param       $subject
	 * @param array $config
	 */
	public function __construct(&$subject, $config = array())
	{
		parent::__construct($subject, $config);

		$jversion = new JVersion();
		if ($jversion->isCompatible('2.5') && !$jversion->isCompatible('3.0'))
		{
			$this->loadLanguage();
		}
	}

	/**
	 * Decide if the field can be edited through the backend manage directories
	 *
	 * @param $field
	 *
	 * @return mixed
	 */
	public function rsfp_on_b_ManageDirectoriesDecideEditable(&$field)
	{
		if (RSFormProHelper::getComponentTypeId($field->FieldName, $field->formId) == $this->componentId)
		{
			$field->allowEdit = false;
		}

		return $field;
	}

	/**
	 * Change the value of the field to an image in the Manage Directories List View
	 *
	 * @param $items
	 * @param $formId
	 *
	 * @return array
	 */
	public function rsfp_onAfterManageDirectoriesQuery(& $items, $formId)
	{
		foreach ($items as $i => $item)
		{
			foreach ($items[$i] as $key => $value)
			{
				if (RSFormProHelper::getComponentTypeId($key, $formId) == $this->componentId)
				{
					$items[$i]->{$key} = '<img src=' . $value . ' />';
				}
				else
				{
					$items[$i]->{$key} = $value;
				}
			}
		}

		return $items;
	}

	/**
	 * Add the new placeholder to the quick add list
	 *
	 * @param $placeholders
	 *
	 * @return mixed
	 */
	public function rsfp_onAfterCreateQuickAddPlaceholders(& $placeholders, $componentId)
	{

		if ($componentId == $this->componentId)
		{
			$placeholders['display'][] = '{' . $placeholders['name'] . ':signature}';
			$placeholders['display'][] = '{' . $placeholders['name'] . ':signature_image}';
		}

		return $placeholders;
	}

	/**
	 * @param $formId
	 * @param $submissionId
	 * @param $column
	 *
	 * @return string
	 */
	public function generateImageLink($formId, $submissionId, $column)
	{
		$config = JFactory::getConfig();
		$secret = $config->get('secret');

		$hashed = md5($formId . $submissionId . $column . $secret);
		$url    = JUri::root() . 'index.php?option=com_rsform&task=plugin&plugin_task=signature.image&hash=' . $hashed;

		return $url;
	}

	/**
	 * @throws Exception
	 */
	public function rsfp_f_onSwitchTasks()
	{
		$input  = JFactory::getApplication()->input;
		$formId = $input->getInt('formId', 0);

		if ($input->getString('plugin_task', '') == 'signature.image')
		{
			$this->signatureReturn($input->getString('hash', ''));
		}
	}

	/**
	 * @param $hash
	 */
	public function signatureReturn($hash)
	{
		$config = JFactory::getConfig();
		$secret = $config->get('secret');
		// Get the image data
		$db    = JFactory::getDBO();
		$query = $db->getQuery(true);
		$query->select($db->qn('FieldValue'))
			->from($db->qn('#__rsform_submission_values'))
			->where('MD5(CONCAT(' . $db->qn('FormId') . ',' . $db->qn('SubmissionId') . ',' . $db->qn('FieldName') . ',' . $db->q($secret) . ')) = ' . $db->q($hash));
		$db->setQuery($query);

		// create the path and save it as png
		$path = JFactory::getApplication()->get('tmp_path') . '/' . $hash . '.png';
		$data = base64_decode(preg_replace('#^data:image/\w+;base64,#i', '', RSFormProHelper::htmlEscape($db->loadResult())));

		jimport('joomla.filesystem.file');

		// Save it
		JFile::write($path, $data);

		// Display it
		header('Content-type: image/png');
		readfile($path);

		// Delete it
		JFile::delete($path);
		exit();
	}

	/**
	 * Display the form field in the left sidebar
	 */
	public function rsfp_bk_onAfterShowComponents()
	{
		$link = "displayTemplate('2787')";

		?>
		<li class="rsform_navtitle"><?php echo JText::_('RSFP_RSFPSIGNATURE_LABEL'); ?></li>
		<li>
			<a href="javascript: void(0);" onclick="<?php echo $link; ?>;return false;" id="rsfp_signature"><span class="rsficon rsficon-pencil-square"></span><span class="inner-text"><?php echo JText::_('RSFP_RSFPSIGNATURE_LABEL'); ?></span></a>
		</li>
		<?php
	}

	/**
	 * Display the form field in the preview window
	 *
	 * @param array $args
	 */
	public function rsfp_bk_onAfterCreateComponentPreview($args = array())
	{
		if ($args['ComponentTypeName'] == 'rsfpsignature')
		{
			$args['out'] = '<td>' . $args['data']['CAPTION'] . '</td>';
			$args['out'] .= '<td><span class="rsficon rsficon-pencil-square" style="font-size:24px; margin-right:5px"></span>' . JText::_("RSFP_RSFPSIGNATURE_SIGNATURE") . '</td>';
		}
	}

	/**
	 * Generate the form field in the frontend
	 *
	 * @param $args
	 */
	public function rsfp_bk_onAfterCreateFrontComponentBody($args)
	{
		$typeId = $args['r']['ComponentTypeId'];

		if ($typeId == 2787)
		{
			$jversion = new JVersion();
			if ($jversion->isCompatible('3.0'))
			{
				JHtml::_('jquery.framework');
			}
			else
			{
				RSFormProAssets::addScript(JUri::root(true) . '/media/com_rsform/js/jquery/jquery.js');
				RSFormProAssets::addScript(JUri::root(true) . '/media/com_rsform/js/jquery/jquery-noconflict.js');
			}

			RSFormProAssets::addScript(JUri::root(true) . '/media/com_rsform/js/jSignature.min.noconflict.js');
			RSFormProAssets::addStyleSheet(JUri::root(true) . '/media/com_rsform/css/signature.css');

			$val = '';

			if (!empty($args['value'][$args['data']['NAME']]))
			{
				$val = $args['value'][$args['data']['NAME']];
			}

			$id = $args['data']['ComponentTypeName'] . $args['data']['componentId'];

			$args['out'] .= '
			<div class="rsfp-signature" ' . $args['data']['ADDITIONALATTRIBUTES'] . '>
				<div class="rsfp-signature-body" id="' . $id . '"></div>
				<input type="hidden" value="' . RSFormProHelper::htmlEscape($val) . '" id="hidden-' . $id . '" name="form[' . $args['data']['NAME'] . ']" />
				<div class="rsfp-signature-footer">
				  <div class="description">' . JText::_("RSFP_RSFPSIGNATURE_SIGNABOVE") . '</div>
				    <button type="button" class="button btn clear-signature" data-clear="' . $id . '" data-action="clear-signature">' . JText::_("RSFP_RSFPSIGNATURE_CLEARSIGNATURE") . '</button>
				</div>
			</div>';

			RSFormProAssets::addScript(JUri::root(true) . '/media/com_rsform/js/signature.script.js');
			RSFormProAssets::addScriptDeclaration("RSFormPro.Signature.ids.push('$id');");
		}
	}

	/**
	 * Hook to create a new placeholder so you can display the signature {FIELDNAME:signature}
	 *
	 * @param $args
	 */
	public function rsfp_onAfterCreatePlaceholders($args)
	{

		$formId       = $args['form']->FormId;
		$submission   = &$args['submission'];
		$placeholders = &$args['placeholders'];
		$values       = &$args['values'];

		$componentIds = RSFormProHelper::componentExists($formId, 2787);
		$all_data     = RSFormProHelper::getComponentProperties($componentIds);

		foreach ($all_data as $data)
		{
			$placeholders[] = '{' . $data['NAME'] . ':signature}';
			$values[]       = !empty($submission->values[$data['NAME']]) ? '<img src="' . RSFormProHelper::htmlEscape($submission->values[$data['NAME']]) . '" />' : '';

			$placeholders[] = '{' . $data['NAME'] . ':signature_image}';
			$values[]       = !empty($submission->values[$data['NAME']]) ? '<img src="' . $this->generateImageLink($formId, $submission->SubmissionId, $data['NAME']) . '" />' : '';
		}

	}

	/**
	 * Function to render the signature in the Backend Manage Submission view
	 *
	 * @param $args
	 */
	public function rsfp_b_onManageSubmissions($args)
	{

		$componentIds = RSFormProHelper::componentExists($args['formId'], 2787);
		$all_data     = RSFormProHelper::getComponentProperties($componentIds);

		foreach ($args['submissions'] as $SubmissionId => $submission)
		{
			foreach ($all_data as $data)
			{
				if (isset($args['submissions'][$SubmissionId]['SubmissionValues'][$data['NAME']]['Value']))
				{
					$args['submissions'][$SubmissionId]['SubmissionValues'][$data['NAME']]['Value'] = '<img src="' . RSFormProHelper::htmlEscape($args['submissions'][$SubmissionId]['SubmissionValues'][$data['NAME']]['Value']) . '" />';
				}

			}
		}

	}

	/**
	 * Add the new form field to the unescapedFields array
	 *
	 * @param $args
	 */
	public function rsfp_b_onManageSubmissionsCreateUnescapedFields($args)
	{
		$componentIds = RSFormProHelper::componentExists($args['formId'], 2787);
		$all_data     = RSFormProHelper::getComponentProperties($componentIds);

		foreach ($all_data as $data)
		{
			$args['fields'][] = $data['NAME'];
		}
	}

	/**
	 * @param $field
	 * @param $placeholders
	 */
	public function rsfp_b_onManageDirectoriesAfterCreatedPlaceholders($field, &$placeholders)
	{
		$componentTypeId = RSFormProHelper::getComponentTypeId($field->FieldName, $field->formId);

		if ($componentTypeId == $this->componentId)
		{
			$placeholders['caption'] = '{' . $field->FieldName . ':caption}';
			$placeholders['value']   = '{' . $field->FieldName . ':signature}';
		}
	}

	/**
	 * @param $args
	 */
	public function rsfp_b_onManageDirectoriesCreateUnescapedFields($args)
	{
		$componentIds = RSFormProHelper::componentExists($args['formId'], 2787);
		$all_data     = RSFormProHelper::getComponentProperties($componentIds);

		foreach ($all_data as $data)
		{
			$args['fields'][] = $data['NAME'];
		}
	}
}