<?php

/**
 * @version     $id: $
 * @author      JoomlaUX!
 * @package     Joomla!
 * @subpackage          mod_jux_news_wall
 * @copyright           Copyright (C) 2012 - 2014 by Joomlaux. All rights reserved.
 * @license     http://www.gnu.org/licenses/gpl-3.0.html GNU/GPL version 3, See LICENSE.txt
 */

// no direct access
defined('_JEXEC') or die;
$count = count($items);
// Fix bugs when don't use carousel
$carousel = 0;
for ($i = 0; $i < count($list); $i++) {
    if ($list[$i]->featured == "1") {
        $carousel = 1;
        break;
    }
}

// Process to get Categories to filter
if($params->get('joomla_filter_by') == "1") {
    $categories = array();
    for($i = 0; $i < count($list); $i++){
        $category[$i] = new stdClass;
        $category[$i]->title = $list[$i]->category_title;
        $category[$i]->alias = $list[$i]->category_alias;
        if(in_array($category[$i], $categories) == false){
            array_push($categories,$category[$i]);
        }
    }
}else{
    $joomla_tags = array();
    for($j = 0; $j < count($list); $j++){
         foreach ($list[$j]->tags_new as $key => $tag) {
            $joomla_tags[$key] = new stdClass;           
            $joomla_tags[$key]->title = $tag->title;
                array_push($joomla_tags,$joomla_tags[$key]);
        }
    }
    $joomla_tags_new = array();
    for($i = 0; $i<count($joomla_tags); $i++){
        $joomla_tags[$i]= $joomla_tags[$i]->title;
        if(in_array($joomla_tags[$i], $joomla_tags_new) == false){
            array_push($joomla_tags_new,$joomla_tags[$i]);
        }
    }
}

?>

<!-- Start K2 Item Layout -->
<div id="news-wall-<?php echo $module->id; ?>" class="itemListView<?php if ($params->get('moduleclass_sfx')) echo ' ' . $params->get('moduleclass_sfx'); ?>">
    <?php if($params->get('filter_category') == "1") { 
        if($params->get('joomla_filter_by') == "1") { ?>

            <div class="news-wall-filters clearfix">
                <ul data-option-key="filter" id="filter">
                    <li class="next">
                        <a class="selected " title="<?php echo JText::_('JUX_NEWS_WALL_ALL')?>" data-option-value="*" href="#"><?php echo JText::_('JUX_NEWS_WALL_ALL')?></a>
                    </li>
                    <?php foreach ($categories as $cat): ?>
                    <li class="next">
                        <a title="<?php echo $cat->title; ?>" data-option-value=".<?php echo $cat->alias; ?>" href="#"><?php echo $cat->title; ?></a>
                    </li>
                    <?php endforeach; ?>
                    <?php if($params->get('filter_search') == "1") : ?>
                    <li class="next search">
                        <input type="text" id="quicksearch" placeholder="<?php echo JText::_('JUX_NEWS_WALL_SEARCH'); ?>" />
                    </li>
                    <?php endif; ?>
                </ul>
                
            </div>
        <?php }else{ ?>

            <div class="news-wall-filters clearfix">
                <ul data-option-key="filter" id="filter">
                    <li class="next">
                        <a class="selected " title="<?php echo JText::_('JUX_NEWS_WALL_ALL')?>" data-option-value="*" href="#"><?php echo JText::_('JUX_NEWS_WALL_ALL')?></a>
                    </li>
                    <?php for ( $i =0; $i < count($joomla_tags_new); $i++){
                        $joomla_tags_new_ = str_replace(" ","_",$joomla_tags_new[$i]);
                    ?>
                    <li class="next">
                        <a title="<?php echo $joomla_tags_new[$i]; ?>" data-option-value=".<?php echo $joomla_tags_new_; ?>" href="#"><?php echo $joomla_tags_new[$i];; ?></a>
                    </li>
                    <?php }?>
                    <?php if($params->get('filter_search') == "1") : ?>
                    <li class="next search">
                        <input type="text" id="quicksearch" placeholder="<?php echo JText::_('JUX_NEWS_WALL_SEARCH'); ?>" />
                    </li>
                    <?php endif; ?>
                </ul>
                
            </div>

        <?php } ?>
    <?php } ?>
    
    <?php if( $count>0 ) : ?>
    <div id="news-itemList-<?php echo $module->id; ?>">
        <?php foreach ($items as $item) : 
        $tags="";
        $item_tags = $item->tags_new;
        for($i = 0; $i < count($item->tags_new); $i++){
            $tag_filter = str_replace(" ","_",$item->tags_new[$i]->title);
            $tags= $tags." ".$tag_filter." ";
        }
        ?>
            <div class="wall-item <?php if($params->get('joomla_filter_by') == "1"){ echo $item->category_alias;}else{echo $tags;} ?>" data-category="<?php echo $item->category_alias; ?>">
                <div class="wall-top">
                    <div class="wall-image">
                        <?php $null_image = "{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}" ?>
                        <?php if ($params->get('item_images') && (($item->images) != $null_image)): ?>
                            <?php
                            $images = json_decode($item->images);
                            if(isset($images->image_intro)){
                                $image = $images->image_intro;
                            }
                            else{
                                $image='';
                            }
                            ?>
                            <?php if ($params->get('joomla_lightbox') == "1"): ?>
                                <a data-lightbox-type="inline"  class="jux-wall-lightbox"  href="#juxWallLightbox<?php echo $item->id ?>" title="<?php echo $item->title; ?>">
                                    <!-- data-lightbox-gallery="jux-wall-gallery" -->
                                    <img src="<?php echo Juri::Base() . $image ?>">
                                </a>
                            <?php endif; ?>
                            <?php if ($params->get('joomla_lightbox') == "0"): ?>
                                <a href="<?php echo $item->link ?>" title="<?php echo $item->title; ?>">
                                    <!-- data-lightbox-gallery="jux-wall-gallery" -->
                                    <img src="<?php echo Juri::Base() . $image ?>">
                                </a>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>

                </div>
                <div class="wall-bottom clearfix">
                    <div class="item-content">
                        <?php if ($params->get('link_titles') == 1) : ?>
                            <h3 class="catItemTitle">
                                <!-- Use lightbox -->
                                <?php if ($params->get('joomla_lightbox') == "1"): ?>
                                    <a data-lightbox-type="inline"  class="jux-wall-lightbox"  href="#juxWallLightbox<?php echo $item->id ?>" title="<?php echo $item->title; ?>"><?php echo $item->title; ?></a>
                                <?php endif; ?>
                                <!-- Don't use lightbox -->
                                <?php if ($params->get('joomla_lightbox') == "0"): ?>
                                    <a href="<?php echo $item->link ?>"><?php echo $item->title; ?></a>
                                <?php endif; ?>
                            </h3>
                            <?php if ($params->get('show_date') == 1): ?>
                                <p class="catItemDateCreated">
                                    <?php echo JHTML::_('date', $item->created, JText::_('K2_DATE_FORMAT_LC5')); ?>
                                </p>
                            <?php endif; ?>
                        <?php endif ?>
                        <!-- Item introtext -->
                        <?php if ($params->get('show_introtext') == 1) : ?>
                            <div class="catItemIntroText">
                                <?php 
                                    $introtext= strip_tags($item->introtext);
                                    $introtext = substr(htmlspecialchars_decode($introtext), 0, $params->get('introtext_limit', 100));
                                       echo $introtext; 
                                    ?>
                            </div>
                        <?php endif; ?>
                        <?php if ($params->get('show_readmore') == 1) : ?>
                            <div class="jux-readmore clearfix">
                                <a href="<?php echo $item->link ?>" alt="<?php echo $item->title; ?>"><?php echo JText::_('JUX_READMORE'); ?></a>
                            </div>
                        <?php endif; ?>
                        <div class="catItemLinks">
                            <?php if($params->get('joomla_filter_by') == "1") {?>
                                <?php if ($params->get('show_category') == 1 ) { ?>
                                    <!-- Item tags -->
                                    <?php if ($item->featured != 1): ?>
                                        <div class="catItemTagsBlock">
                                            <b><?php echo JText::_('JUX_CATS'); ?>:</b>
                                            <a href="<?php echo $item->displayCategoryLink ?>"><?php echo $item->category_title; ?></a>
                                        </div>
                                    <?php endif; ?>
                                <?php } ?>
                            <?php } else {?>    
                                <div class="catItemTagsBlock">
                                    <?php if(count($item_tags) >0) { ?>
                                        <b><?php echo JText::_('JUX_TAGS'); ?>:</b> 
                                    <?php } ?>
                                    <?php for($j = 0; $j < count($item_tags); $j++){ 
                                    $item_tag_link =JURI::base().'index.php/component/tags/tag/'.$item->id.'-'.str_replace(" ","_",$item_tags[$j]->title);
                                    ?>
                                    <a href="<?php echo $item_tag_link; ?>">
                                    <?php 
                                            if($j < count($item_tags)-1){
                                               echo "#".$item_tags[$j]->title.", ";
                                            }else{
                                                echo"#".$item_tags[$j]->title;
                                            }
                                    ?>
                                         
                                    </a>
                                    <?php }?>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
                <!-- nivo lightbox -->
                <div id="juxWallLightbox<?php echo $item->id ?>" style="display:none">
                    <div class="lightboxContainer">
                        <div class="itemViewLightBox">
                            <!-- Item lightbox Body -->
                            <div class="itemViewBody">
                                <div class="itemViewContent">
                                    <div class="lb_itemImageBlock">
                                        <img src="<?php echo Juri::Base() . $image ?>" alt="<?php echo $item->title; ?>"/> 
                                    </div>
                                </div>
                                <div class="lb_itemView">
                                    <!-- Item lightbox header -->
                                    <div class="itemViewHeader"><h2><?php echo $item->title ?></h2></div>
                                    <!-- Item lightbox Info-->
                                    <div class="itemViewInfo">
                                        <!-- item date created -->
                                        <span class="itemDateCreated">
                                            <?php echo JHTML::_('date', $item->created, JText::_('K2_DATE_FORMAT_LC5')); ?>
                                        </span>
                                        <i class="lb_icon-line"></i>
                                        <!-- item author -->
                                        <span class="itemViewAuthor">
                                            <i class="lb_icon-author"></i>
                                            <a rel="author" href=""><?php echo $item->author ?></a>
                                        </span>
                                        <i class="lb_icon-line"></i>
                                        <!-- Item Hits -->
                                        <span class="itemViewHits">
                                            <i class="lb_icon-hits"></i>
                                            <?php echo $item->hits ?>
                                            <i class="lb_icon-line"></i>
                                        </span>
                                    </div>
                                    <div class="lb_itemIntroText">
                                        <?php echo $item->introtext ?>
                                    </div>
                                    <div class="lb_itemFullText">
                                        <?php echo $item->fulltext ?>
                                    </div>
                                </div>
                            </div>
                            <div class="itemViewContentFooter">
                                <div class="itemSocialSharing"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
    <?php endif; ?>
    <?php // endif; ?>
    <div class="items-isotope-loading">
        <div class="loading_spinner_wrapper" style="display: none">
            <div class="cube1"></div>
            <div class="cube2"></div>
            <div class="cube3"></div>
            <div class="cube4"></div>
            <div class="cube5"></div>
        </div>
    </div>
     <?php if( $count != $total) : ?>
    <div class="news-wall-loadmore">
        <a href="#" class="btn btn-primary btn-large btn-loadmore">
            <span id="loadmore-text"><?php echo JText::_('JUX_VIEW_MORE'); ?></span>
        </a>
    </div>
    <?php endif; ?>
</div>
 
<script type="text/javascript">
    !function ($) {
        $(document).ready(function () {

        });
    }(jQuery);
</script>

<?php if($params->get('filter-gray') == "1") : ?>
<script>
    !function($){
        // Fix on iOS
        var user_agent = navigator.userAgent.toLowerCase(); // detect the user agent
        var ios_devices = user_agent.match(/(iphone|ipod|ipad)/) ? true : false;
        // console.log(ios_devices);

        /*
        * Hover Gray
        */
        if(ios_devices != true){
            $("#news-itemList-<?php echo $module->id; ?> .wall-item").mouseenter(
                function () {
                    $('.wall-item').addClass('filter-gray');
                    $(this).removeClass('filter-gray');
                }
            );

            // Leave hover items
            $('#news-itemList-<?php echo $module->id; ?>').mouseleave(
                function () {
                    $('.wall-item').removeClass('filter-gray');
                }
            );
        }
        
    }(jQuery);
</script>
<?php endif; ?>

<script>
jQuery("ul#filter>li a:first").addClass('active');
jQuery('.news-wall-filters li a').on('click', function (e) {
    e.preventDefault();
    jQuery('.news-wall-filters li a.active').removeClass('active');
    jQuery(this).addClass('active');
});
</script>

<!--Clone Ajax loadmore items-->
<script type="text/javascript">
    !function ($) {
        $(document).ready(function(){
            // quick search regex
            var qsRegex;
            var buttonFilter;
            var $container = $('#news-itemList-<?php echo $module->id; ?>');

            $container.imagesLoaded().progress( function() {
                $container.isotope({
                    // options
                    itemSelector : '.wall-item',
                    filter: function() {
                        var $this = $(this);
                        var searchResult = qsRegex ? $this.text().match( qsRegex ) : true;
                        var buttonResult = buttonFilter ? $this.is( buttonFilter ) : true;
                        return searchResult && buttonResult;
                    },
                    layoutMode : 'masonry'
                });
            });
            var $currentURL = '<?php echo  JURI::getInstance()->toString(); ?>';
            var $start = <?php echo $limit ?>;  // ajax start from last limit
            var $limit = <?php echo $ajaxlimit ?>;
            var $totalitem = <?php echo $total ?>;

            var user_agent = navigator.userAgent.toLowerCase(); // detect the user agent
            var ios_devices = user_agent.match(/(iphone|ipod|ipad)/)  ? "touchstart" : "click"; //check if the devices are ios devices

            $('.news-wall-loadmore > a').on('click', function(e) {
                var $this = $(this);

                $('.loading_spinner_wrapper').css('display','block');

                $.post($currentURL, { moduleID: <?php echo $module->id; ?>, start:$start, limit: $limit }, function(data){

                    $start += $limit;

                    var $newItems = $(data);
                    
                    $container.isotope( 'insert', $newItems );
                    // layout Isotope after each image loads
                    $container.imagesLoaded().progress( function() {
                        $container.isotope('layout');
                        var imgLoad = imagesLoaded( $container );
                        imgLoad.on( 'always', function( instance ) {
                            setTimeout(function(){
                                $('.loading_spinner_wrapper').css("display","none");
                            },200);
                        });
                        
                        // nivo Lightbox when loadmore items
                        $('.jux-wall-lightbox').nivoLightbox();
                    });

                    if( $totalitem <= $start ) {
                        $('.news-wall-loadmore').html('<span class="btn-loadmore"><?php echo JText::_("JUX_VIEW_MORE_NO_MORE_ITEMS"); ?></span>');

                        return false;
                    } else {

                    }
                });
                
                return false;
            });
            
            $('.jux-wall-lightbox').nivoLightbox();
            

            // bind filter button click
            $('.news-wall-filters').on( 'click', 'a', function() {
                buttonFilter = jQuery( this ).attr('data-option-value');
                $container.isotope();
            });
            
            // use value of search field to filter
            var $quicksearch = $('#quicksearch').keyup( debounce( function() {
                qsRegex = new RegExp( $quicksearch.val(), 'gi' );
                $container.isotope();
            }) );

            
           
        });

        // debounce so filtering doesn't happen every millisecond
        function debounce( fn, threshold ) {
            var timeout;
            return function debounced() {
                if ( timeout ) {
                    clearTimeout( timeout );
                }
                function delayed() {
                    fn();
                    timeout = null;
                }
                setTimeout( delayed, threshold || 100 );
            };
        }
    }(jQuery);
</script>