
<?php

/**
 * @version     $id: $
 * @author      JoomlaUX!
 * @package     Joomla!
 * @subpackage          mod_jux_news_wall
 * @copyright           Copyright (C) 2012 - 2014 by Joomlaux. All rights reserved.
 * @license     http://www.gnu.org/licenses/gpl-3.0.html GNU/GPL version 3, See LICENSE.txt
 */

// no direct access
defined('_JEXEC') or die;
$count = count($items);
// Fix bugs when don't use carousel
$carousel = 0;
for ($i = 0; $i < count($list); $i++) {
    if ($list[$i]->featured == "1") {
        $carousel = 1;
        break;
    }
}

// Process to get Categories to filter
$categories = array();
for($i = 0; $i < count($list); $i++){
    $category[$i] = new stdClass;
    $category[$i]->title = $list[$i]->categoryname;
    $category[$i]->alias = $list[$i]->categoryalias;
    if(in_array($category[$i], $categories) == false){
        array_push($categories,$category[$i]);
    }
}

?>

<!-- Start K2 Item Layout -->
<div id="news-wall-<?php echo $module->id; ?>" class="itemListView<?php if ($params->get('moduleclass_sfx')) echo ' ' . $params->get('moduleclass_sfx'); ?>">
    <?php if($params->get('filter_category') == "1" && $params->get('jux-filter') == "1") :  ?>
        <div class="news-wall-filters clearfix">
            <ul data-option-key="filter" id="filter">
                <li class="next">
                    <a class="selected " title="<?php echo JText::_('JUX_NEWS_WALL_ALL')?>" data-option-value="*" href="#"><?php echo JText::_('JUX_NEWS_WALL_ALL')?></a>
                </li>
                <?php foreach ($categories as $cat): ?>
                <li class="next">
                    <a title="<?php echo $cat->title; ?>" data-option-value=".<?php echo $cat->alias; ?>" href="#"><?php echo $cat->title; ?></a>
                </li>
                <?php endforeach; ?>
                <?php if($params->get('filter_search') == "1") : ?>
                <li class="next search">
                    <input type="text" id="quicksearch" placeholder="<?php echo JText::_('JUX_NEWS_WALL_SEARCH'); ?>" />
                </li>
                <?php endif; ?>
            </ul>
            
        </div>
    <?php endif; ?>
    <?php if ($params->get('jux-filter') == "0") { ?>
        <div class="news-wall-filters clearfix">
            <ul data-option-key="filter" id="filter">
                <li class="next">
                    <a class="selected " title="<?php echo JText::_('JUX_NEWS_WALL_ALL')?>" data-option-value="*" href="#"><?php echo JText::_('JUX_NEWS_WALL_ALL')?></a>
                </li>
                <?php foreach($tags as $tag) { 
                $tagnew = str_replace(" ","",$tag->name);
                ?>
                <li class="next">
                    <a title="<?php echo $tagnew; ?>" data-option-value=".<?php echo $tagnew; ?>" href="#"><?php echo $tag->name; ?></a>
                </li>
                <?php } ?>
                <?php if($params->get('filter_search') == "1") : ?>
                <li class="next search">
                    <input type="text" id="quicksearch" placeholder="<?php echo JText::_('JUX_NEWS_WALL_SEARCH'); ?>" />
                </li>
                <?php endif; ?>
            </ul>
            
        </div>

    <?php } ?>
    <?php // if( $ajaxRequest ) : ?>
    <?php if( $count>0 ) : ?>
    <div id="news-itemList-<?php echo $module->id; ?>">
        <?php  foreach ($items as $item) :
            $tagsitem= $item ->tags;
            $tagsarr = array(); 
           foreach ($item->tags as $tag){                  
                $tagnew = str_replace(" ","",$tag->name);
                $tagsarr[]= $tagnew;
            }
            $tagsarr= implode(" ",$tagsarr); 

        ?>
            <div class="wall-item <?php echo $tagsarr; ?> <?php  echo $item->categoryalias; ?>" data-category="<?php echo $item->categoryalias; ?>">
                <div class="wall-top">
                    <div class="wall-image">
                        <?php if($params->get('itemImage') && isset($item->image)): ?>
                            <!-- If use lightbox -->
                            <?php if($params->get('k2_lightbox') == "1"):?>
                            <a data-lightbox-type="inline"  class="jux-wall-lightbox"  href="#juxWallLightbox<?php echo $item->id ?>" title="<?php echo K2HelperUtilities::cleanHtml($item->title); ?>">
                                <img src="<?php echo JURI::root().'media/k2/items/src/'.md5("Image".$item->id).'.jpg'; ?>" alt="<?php echo $item->title; ?>"/> 
                            </a>
                            <?php endif; ?>
                            <!-- If not use lightbox -->
                            <?php if($params->get('k2_lightbox') == "0"):?>
                            <a href="<?php echo $item->link ?>" title="<?php echo K2HelperUtilities::cleanHtml($item->title); ?>">
                                <img src="<?php echo JURI::root().'media/k2/items/src/'.md5("Image".$item->id).'.jpg'; ?>" alt="<?php echo $item->title; ?>"/> 
                            </a>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>

                    <!-- display video -->
                    <?php if($params->get('itemVideo') && ($item->video != "")): ?>
                    <div class="wall-video">
                        <?php echo $item->video ; ?>
                        <span class="moduleItemVideoCaption"><?php echo $item->video_caption ; ?></span>
                        <span class="moduleItemVideoCredits"><?php echo $item->video_credits ; ?></span>
                    </div>
                    <?php endif; ?>
                </div>
                <div class="wall-bottom clearfix">
                    <div class="item-content">
                        <?php if($params->get('itemTitle')): ?>
                        <h3 class="catItemTitle">
                                <?php if($params->get('k2_lightbox') == "1"):?>
                                <a data-lightbox-type="inline"  class="jux-wall-lightbox"  href="#juxWallLightbox<?php echo $item->id ?>" title="<?php echo K2HelperUtilities::cleanHtml($item->title); ?>"><?php echo $item->title; ?></a>
                                <!-- If not use lightbox -->
                                <?php endif;?>
                                <?php if($params->get('k2_lightbox') == "0"):?>
                                    <a href="<?php echo $item->link ?>" title="<?php echo K2HelperUtilities::cleanHtml($item->title); ?>"><?php echo $item->title; ?></a>
                                <?php endif; ?>
                        </h3>
                        <?php if($params->get('itemDateCreated')): ?>
                            <p class="catItemDateCreated">
                                <?php echo JHTML::_('date', $item->created, JText::_('K2_DATE_FORMAT_LC5')); ?>
                            </p>
                            <?php endif; ?>
                        <?php endif; ?>
                        <!-- Item introtext -->
                        <?php if($params->get('itemIntroText')): ?>
                        <div class="catItemIntroText">
                            <?php if (strlen($item->introtext)>($params->get('itemIntroTextWordLimit',50))): ?>
                            <?php
                            if($params->get('itemIntroTextWordLimit')){
                                echo $item->introtext;
                            }else { 
                                echo $item->introtext;
                                }
                            ?>
                            <?php endif; ?>
                        </div>
                        <?php endif; ?>
                        <?php if ($params->get('itemReadMore') == 1) : ?>
                            <div class="jux-readmore clearfix">
                                <a href="<?php echo $item->link ?>" alt="<?php echo $item->title; ?>"><?php echo JText::_('JUX_READMORE'); ?></a>
                            </div>
                        <?php endif; ?>
                        <div class="catItemLinks">
                            <?php if($params->get('itemTags') && count($item->tags)>0 && ($item->featured != 1)): ?>
                            <!-- Item tags -->
                            <div class="catItemTagsBlock">
                                    <b><?php echo JText::_('JUX_TAGS'); ?>:</b>
                                    <ul class="catItemTags">
                                        <?php  foreach ($item->tags as $tag): ?>
                                        <?php if($tag != $item->tags[sizeof($item->tags) - 1]):?>
                                        <li><a href="<?php echo $tag->link; ?>"><?php echo $tag->name.' ,'; ?></a></li>
                                        <?php else:?>
                                        <li><a href="<?php echo $tag->link; ?>"><?php echo $tag->name; ?></a></li>
                                        <?php endif;?>
                                        <?php endforeach; ?>
                                    </ul>   
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <!-- nivo lightbox -->
                <div id="juxWallLightbox<?php echo $item->id ?>" style="display:none">
                    <div class="lightboxContainer">
                        <div class="itemViewLightBox">
                            <!-- Item lightbox Body -->
                            <div class="itemViewBody">
                                <div class="itemViewContent">
                                    <?php if (isset($item->image) && ($item->image)!=null):?>
                                    <div class="lb_itemImageBlock">
                                            <img src="<?php echo JURI::root().'media/k2/items/src/'.md5("Image".$item->id).'.jpg'; ?>" alt="<?php echo $item->title; ?>"/> 
                                    </div>
                                    <?php endif?>
                                    <div class="lb_itemViewVideo">
                                            <?php echo $item->video ?>
                                    </div>
                                </div>
                                <div class="lb_itemView">
                                <!-- Item lightbox header -->
                                    <div class="itemViewHeader"><h2><?php echo $item->title ?></h2></div>
                                    <!-- Item lightbox Info-->
                                    <div class="itemViewInfo">
                                            <!-- item date created -->
                                            <span class="itemDateCreated">
                                                    <?php echo JHTML::_('date', $item->created, JText::_('K2_DATE_FORMAT_LC5')); ?>
                                            </span>
                                            <i class="lb_icon-line"></i>
                                            <!-- item author -->
                                            <span class="itemViewAuthor">
                                                    <i class="lb_icon-author"></i>
                                                    <a rel="author" href=""><?php echo $item->author ?></a>
                                            </span>
                                            <i class="lb_icon-line"></i>
                                            <!-- Item Hits -->
                                            <span class="itemViewHits">
                                                    <i class="lb_icon-hits"></i>
                                                    <?php echo $item->hits ?>
                                                    <i class="lb_icon-line"></i>
                                            </span>
                                    </div>
                                    <div class="lb_itemIntroText">
                                            <?php echo $item->introtext ?>
                                    </div>
                                    <div class="lb_itemFullText">
                                            <?php echo $item->fulltext ?>
                                    </div>
                                </div>
                            </div>
                            <div class="itemViewContentFooter">
                                <div class="itemSocialSharing"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
    <?php endif; ?>
    <?php // endif; ?>
    <div class="items-isotope-loading">
        <div class="loading_spinner_wrapper" style="display: none">
            <div class="cube1"></div>
            <div class="cube2"></div>
            <div class="cube3"></div>
            <div class="cube4"></div>
            <div class="cube5"></div>
        </div>
    </div>
    <?php if( $count != $total) : ?>
    <div class="news-wall-loadmore">
        <a href="#" class="btn btn-primary btn-large btn-loadmore">
            <span id="loadmore-text"><?php echo JText::_('JUX_VIEW_MORE'); ?></span>
        </a>
    </div>
    <?php endif; ?>
</div>
 
<script type="text/javascript">
    !function ($) {
        $(document).ready(function () {

        });
    }(jQuery);
</script>

<?php if($params->get('filter-gray') == "1") : ?>
<script>
    !function($){
        /*
        * Hover Gray
        */
        $("#news-itemList-<?php echo $module->id; ?> .wall-item").mouseenter(
            function () {
                $('.wall-item').addClass('filter-gray');
                $(this).removeClass('filter-gray');
            }
        );

        // Leave hover items
        $('#news-itemList-<?php echo $module->id; ?>').mouseleave(
            function () {
                $('.wall-item').removeClass('filter-gray');
            }
        );
    }(jQuery);
</script>
<?php endif; ?>

<script>
jQuery("ul#filter>li a:first").addClass('active');
jQuery('.news-wall-filters li a').on('click', function (e) {
    e.preventDefault();
    jQuery('.news-wall-filters li a.active').removeClass('active');
    jQuery(this).addClass('active');
});
</script>

<!--Clone Ajax loadmore items-->
<script type="text/javascript">
    !function ($) {
        $(document).ready(function(){
            // quick search regex
            var qsRegex;
            var buttonFilter;
            var $container = $('#news-itemList-<?php echo $module->id; ?>');

            $container.imagesLoaded().progress( function() {
                $container.isotope({
                    // options
                    itemSelector : '.wall-item',
                    filter: function() {
                        var $this = $(this);
                        var searchResult = qsRegex ? $this.text().match( qsRegex ) : true;
                        var buttonResult = buttonFilter ? $this.is( buttonFilter ) : true;
                        return searchResult && buttonResult;
                    },
                    layoutMode : 'masonry'
                });
            });
            var $currentURL = '<?php echo  JURI::getInstance()->toString(); ?>';
            var $limitstart = <?php echo $limit ?>;
            var $ajaxlimit = <?php echo $ajaxlimit ?>;
            var $limit =   $ajaxlimit;
            var $totalitem = <?php echo $total ?>;

            $('.news-wall-loadmore > a').on('click', function(e){
                var $this = $(this);
                $('.loading_spinner_wrapper').css('display','block');

                $.post($currentURL, { moduleID: <?php echo $module->id; ?>, limitstart:$limitstart, limit: $limit }, function(data){
                    $limitstart += $ajaxlimit;

                    var $newItems = $(data);
                    $container.isotope( 'insert', $newItems );
                    // layout Isotope after each image loads
                    $container.imagesLoaded().progress( function() {
                        $container.isotope('layout');
                        var imgLoad = imagesLoaded( $container );
                        imgLoad.on( 'always', function( instance ) {
                            setTimeout(function(){
                                $('.loading_spinner_wrapper').css("display","none");
                            },200);
                        });
                        
                        // nivo Lightbox when loadmore items
                        $('.jux-wall-lightbox').nivoLightbox({
                            effect: 'fadeScale',                        // The effect to use when showing the lightbox
                            theme: 'default',                           // The lightbox theme to use
                            keyboardNav: true,                          // Enable/Disable keyboard navigation (left/right/escape)
                            clickOverlayToClose: true,                  // If false clicking the "close" button will be the only way to close the lightbox
                            onInit: function(){},                       // Callback when lightbox has loaded
                            beforeShowLightbox: function(){},           // Callback before the lightbox is shown
                            afterShowLightbox: function(lightbox){},    // Callback after the lightbox is shown
                            beforeHideLightbox: function(){},           // Callback before the lightbox is hidden
                            afterHideLightbox: function(){},            // Callback after the lightbox is hidden
                            onPrev: function(element){},                // Callback when the lightbox gallery goes to previous item
                            onNext: function(element){},                // Callback when the lightbox gallery goes to next item
                            errorMessage: 'The requested content cannot be loaded. Please try again later.' // Error message when content can't be loaded
                        });
                    });

                    if( $totalitem <= $limitstart ){
                        $('.news-wall-loadmore').html('<span class="btn-loadmore"><?php echo JText::_("JUX_VIEW_MORE_NO_MORE_ITEMS"); ?></span>');
                        return false;
                    } else {

                    }
                });
                
                return false;
            });
            
            // nivo Lightbox loaded items when start
            $('.jux-wall-lightbox').nivoLightbox({
                effect: 'fadeScale',                             // The effect to use when showing the lightbox
                theme: 'default',                           // The lightbox theme to use
                keyboardNav: true,                          // Enable/Disable keyboard navigation (left/right/escape)
                clickOverlayToClose: true,                  // If false clicking the "close" button will be the only way to close the lightbox
                onInit: function(){},                       // Callback when lightbox has loaded
                beforeShowLightbox: function(){},           // Callback before the lightbox is shown
                afterShowLightbox: function(lightbox){},    // Callback after the lightbox is shown
                beforeHideLightbox: function(){},           // Callback before the lightbox is hidden
                afterHideLightbox: function(){},            // Callback after the lightbox is hidden
                onPrev: function(element){},                // Callback when the lightbox gallery goes to previous item
                onNext: function(element){},                // Callback when the lightbox gallery goes to next item
                errorMessage: 'The requested content cannot be loaded. Please try again later.' // Error message when content can't be loaded
            });
            
           // bind filter button click
            $('.news-wall-filters').on( 'click', 'a', function() {
                buttonFilter = jQuery( this ).attr('data-option-value');
                $container.isotope();
            });
            
            // use value of search field to filter
            var $quicksearch = $('#quicksearch').keyup( debounce( function() {
                qsRegex = new RegExp( $quicksearch.val(), 'gi' );
                $container.isotope();
            }) );

        });
        
        // debounce so filtering doesn't happen every millisecond
        function debounce( fn, threshold ) {
            var timeout;
            return function debounced() {
                if ( timeout ) {
                    clearTimeout( timeout );
                }
                function delayed() {
                    fn();
                    timeout = null;
                }
                setTimeout( delayed, threshold || 100 );
            };
        }
        
    }(jQuery);
</script>